#define	TwoPi  6.28318530717958648
const	double eps=1e-14;

/// Расчет кубического корня 
double exampleGroup_exampleType3::_root3 ( double x )
{
    double s = 1.;
    while ( x < 1. )
    {
        x *= 8.;
        s *= 0.5;
    }
    while ( x > 8. )
    {
        x *= 0.125;
        s *= 2.;
    }
    double r = 1.5;
    r -= 1./3. * ( r - x / ( r * r ) );
    r -= 1./3. * ( r - x / ( r * r ) );
    r -= 1./3. * ( r - x / ( r * r ) );
    r -= 1./3. * ( r - x / ( r * r ) );
    r -= 1./3. * ( r - x / ( r * r ) );
    r -= 1./3. * ( r - x / ( r * r ) );
    return r * s;
}


/// Знак и получение кубического корня
double exampleGroup_exampleType3::root3 ( double x )
{
    if ( x > 0 ) return _root3 ( x ); else
    if ( x < 0 ) return-_root3 (-x ); else
    return 0.;
}

int exampleGroup_exampleType3::solveP3(double *x,double a,double b,double c) {
	double a2 = a*a;
    double q  = (a2 - 3*b)/9; 
	double r  = (a*(2*a2-9*b) + 27*c)/54;
	// уравнение y^3 - 3q*y + r/2 = 0, где x = y-a/3
	if (fabs(q) < eps) {		// y^3 =-r/2
		if (fabs(r) < eps) {	// три идентичных корня
			x[0] = x[1] = x[2] = -a/3;
			return(3);
		}
		// y^3 =-r/2
		x[0] = root3(-r/2);
		x[1] = x[0] * 0.5;
		x[2] = x[0] * sqrt(3.) / 2;
		return(1);
	}
	// теперь favs(q)>eps
    double r2 = r*r;
	double q3 = q*q*q;
	double A,B;
	if (r2 <= (q3 + eps)) {
		double t=r/sqrt(q3);
		if( t<-1) t=-1;
		if( t> 1) t= 1;
        t=acos(t);
        a/=3; q=-2*sqrt(q);
        x[0]=q*cos(t/3)-a;
        x[1]=q*cos((t+TwoPi)/3)-a;
        x[2]=q*cos((t-TwoPi)/3)-a;
        return(3);
    } else {
        //A =-pow(fabs(r)+sqrt(r2-q3),1./3); 
        A =-root3(fabs(r)+sqrt(r2-q3)); 
		if( r<0 ) A=-A;
		B = (A==0? 0 : B=q/A);

		a/=3;
		x[0] =(A+B)-a;
        x[1] =-0.5*(A+B)-a;
        x[2] = 0.5*sqrt(3.)*(A-B);
		if(fabs(x[2])<eps) { x[2]=x[1]; return(2); }
        return(1);
    }
}

void  exampleGroup_exampleType3::cSqrt( double x, double y, double &a, double &b)
{
	double r  = sqrt(x*x+y*y);
	if( y==0 ) { 
		r = sqrt(r);
		if(x>=0) { a=r; b=0; } else { a=0; b=r; }
	} else {		// y != 0
		a = sqrt(0.5*(x+r));
		b = 0.5*y/a;
	}
}

int exampleGroup_exampleType3::solveP4Bi(double *x, double b, double d)	
{
	double D = b*b-4*d;
	if( D>=0 ) 
	{
		double sD = sqrt(D);
		double x1 = (-b+sD)/2;
		double x2 = (-b-sD)/2;	// x2 <= x1
		if( x2>=0 )				// 0 <= x2 <= x1, 4 действительных корня
		{
			double sx1 = sqrt(x1);
			double sx2 = sqrt(x2);
			x[0] = -sx1;
			x[1] =  sx1;
			x[2] = -sx2;
			x[3] =  sx2;
			return 4;
		}
		if( x1 < 0 )				// x2 <= x1 < 0, две пары мнимых корней
		{
			double sx1 = sqrt(-x1);
			double sx2 = sqrt(-x2);
			x[0] =    0;
			x[1] =  sx1;
			x[2] =    0;
			x[3] =  sx2;
			return 0;
		}
		// now x2 < 0 <= x1, два действительных корня и одна пара мнимых корней
			double sx1 = sqrt( x1);
			double sx2 = sqrt(-x2);
			x[0] = -sx1;
			x[1] =  sx1;
			x[2] =    0;
			x[3] =  sx2;
			return 2;
	} else { // if( D < 0 ), two pair of compex roots
		double sD2 = 0.5*sqrt(-D);
		cSqrt(-0.5*b, sD2, x[0],x[1]);
		cSqrt(-0.5*b,-sD2, x[2],x[3]);
		return 0;
	} // if( D>=0 ) 
} 

#define SWAP(a,b) { t=b; b=a; a=t; }
void  exampleGroup_exampleType3::dblSort3( double &a, double &b, double &c) // make: a <= b <= c
{
	double t;
	if( a>b ) SWAP(a,b);	// now a<=b
	if( c<b ) {
		SWAP(b,c);			// now a<=b, b<=c
		if( a>b ) SWAP(a,b);// now a<=b
	}
}

int   exampleGroup_exampleType3::solveP4De(double *x, double b, double c, double d)
{
	//if( c==0 ) return SolveP4Bi(x,b,d); // После этого, c!=0
	if( fabs(c)<1e-14*(fabs(b)+fabs(d)) ) return solveP4Bi(x,b,d); // После этого, c!=0

	int res3 = solveP3( x, 2*b, b*b-4*d, -c*c);
	//По теореме Виета:  x1*x2*x3=-c*c не равно 0, поэтому x1!=0, x2!=0, x3!=0
	if( res3>1 )	// 3 real roots, 
	{				
		dblSort3(x[0], x[1], x[2]);	// сортировка корней x[0] <= x[1] <= x[2]
		// Важно: x[0]*x[1]*x[2]= c*c > 0
		if( x[0] > 0) // все корни положительные
		{
			double sz1 = sqrt(x[0]);
			double sz2 = sqrt(x[1]);
			double sz3 = sqrt(x[2]);
			// Важно: sz1*sz2*sz3= -c (и не равны 0)
			if( c>0 )
			{
				x[0] = (-sz1 -sz2 -sz3)/2;
				x[1] = (-sz1 +sz2 +sz3)/2;
				x[2] = (+sz1 -sz2 +sz3)/2;
				x[3] = (+sz1 +sz2 -sz3)/2;
				return 4;
			}
			// Теперь: c<0
			x[0] = (-sz1 -sz2 +sz3)/2;
			x[1] = (-sz1 +sz2 -sz3)/2;
			x[2] = (+sz1 -sz2 -sz3)/2;
			x[3] = (+sz1 +sz2 +sz3)/2;
			return 4;
		} // if( x[0] > 0) // Все корни положительны
		// now x[0] <= x[1] < 0, x[2] > 0
		double sz1 = sqrt(-x[0]);
		double sz2 = sqrt(-x[1]);
		double sz3 = sqrt( x[2]);

		if( c>0 )	// знак = -1
		{
			x[0] = -sz3/2;					
			x[1] = ( sz1 -sz2)/2;		// x[0]+-i*x[1]
			x[2] =  sz3/2;
			x[3] = (-sz1 -sz2)/2;		// x[2]+-i*x[3]
			return 0;
		}
		// Теперь: c<0 , знак = +1
		x[0] =   sz3/2;
		x[1] = (-sz1 +sz2)/2;
		x[2] =  -sz3/2;
		x[3] = ( sz1 +sz2)/2;
		return 0;
	} // if( res3>1 )	// 3 действительных корня
	// x[0] - действительный корень и x[0]>0, 
	// x[1]+-i*x[2] - комплексные корни, 
	// x[0] должен быть >=0. Но иногда x[0]=~ 1e-17, поэтому:
	if (x[0] < 0) x[0] = 0;
	double sz1 = sqrt(x[0]);
	double szr, szi;
	cSqrt(x[1], x[2], szr, szi);  // (szr+i*szi)^2 = x[1]+i*x[2]
	if( c>0 )	// знак = -1
	{
		x[0] = -sz1/2-szr;			// Первый действительный корень
		x[1] = -sz1/2+szr;			// Второй действительный корень
		x[2] = sz1/2; 
		x[3] = szi;
		return 2;
	}
	// Теперь: c<0 , знак = +1
	x[0] = sz1/2-szr;			// Первый действительный корень
	x[1] = sz1/2+szr;			// Второй действительный корень
	x[2] = -sz1/2;
	x[3] = szi;
	return 2;
}

double exampleGroup_exampleType3::n4Step(double x, double a,double b,double c,double d)	// один шаг Ньютона для x^4 + a*x^3 + b*x^2 + c*x + d
{
	double fxs= ((4*x+3*a)*x+2*b)*x+c;	// f'(x)
	if (fxs == 0) return x;
	double fx = (((x+a)*x+b)*x+c)*x+d;	// f(x)
	return x - fx/fxs;
} 

int   exampleGroup_exampleType3::solveP4(double *x,double a,double b,double c,double d) {
	// на a=0:
	double d1 = d + 0.25*a*( 0.25*b*a - 3./64*a*a*a - c);
	double c1 = c + 0.5*a*(0.25*a*a - b);
	double b1 = b - 0.375*a*a;
	int res = solveP4De( x, b1, c1, d1);
	if( res==4) { x[0]-= a/4; x[1]-= a/4; x[2]-= a/4; x[3]-= a/4; }
	else if (res==2) { x[0]-= a/4; x[1]-= a/4; x[2]-= a/4; }
	else             { x[0]-= a/4; x[2]-= a/4; }
	// один шаг Ньютона для каждого действительного корня
	if( res>0 )
	{
		x[0] = n4Step(x[0], a,b,c,d);
		x[1] = n4Step(x[1], a,b,c,d);
	}
	if( res>2 )
	{
		x[2] = n4Step(x[2], a,b,c,d);
		x[3] = n4Step(x[3], a,b,c,d);
	}
	return res;
}