/// Для решения уравнений 4-й степени методом Декарта — Эйлера.
/// x - Маccив double длиной 4
///		return 0: Возвращает 2 пары пары комплексно сопряженных корней. x[0]+-i*x[1] и x[2]+-i*x[3] - сами корни.
///		return 2: Возвращает две пары действительных и две пары сопряженных корней. x[0],x[1] - действительные корни и x[2]+-i*x[3] - пара комплексно сопряженных.
///		return 4: Возвращает 4 действительных корня в x[0],x[1],x[2],x[3].
int   solveP4(double *x,double a,double b,double c,double d);

// ------------------------
// Вспомонательные функции

void  dblSort3( double &a, double &b, double &c);

/// Расчет кубического корня 
double _root3 ( double x );

/// Знак и получение кубического корня
double root3 ( double x );


/// Для решения кубических уравнений через триногометрическую формулу Виета
/// x - Маccив double длиной 4
int   solveP3(double* x, double a, double b, double c);


/// Решение биквадратного уравнения. x^4 + b*x^2 + d = 0
/// x - Маccив double длиной 4
int   solveP4Bi(double *x, double b, double d);


/// Решение неполного уравнения
/// x - Маccив double длиной 4>
int   solveP4De(double *x, double b, double c, double d);


/// Извлечения квадратного корня из комплексного числа. a+i*s = sqrt(x+i*y)
void  cSqrt( double x, double y, double &a, double &b);

/// Метод Ньютона
double n4Step(double x, double a,double b,double c,double d);

